<?php
/**
 * Template part for displaying page content in page.php
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Whiteboard64 Pro
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="col-xs-12 col-sm-12 listings wow fadeInUp" data-wow-duration="2s">
		<!-- Add Banner -->
		<?php if ( is_active_sidebar( 'innerpage1-ad-block' ) ) : ?>
			<?php dynamic_sidebar( 'innerpage1-ad-block' ); ?>
		<?php endif; ?>


		<?php
			if ( is_single() ) {
				the_title( '<h1 class="entry-title">', '</h1>' );
			}

			if ( 'post' === get_post_type() ) : ?>
				<!-- Full meta -->
			    <div class="full_meta clearfix">
			    	<div class="meta_format"><i class="fa fa-calendar"></i>  <?php echo whiteboard64_pro_time_ago(); ?></div>
			        <div class="meta_format"><i class="fa fa-user"></i> <?php echo get_the_author_meta('display_name');?></div>	 
			        <div class="meta_format"><i class="fa fa-folder"></i> <?php echo the_category();?></div>       
			        <div class="meta_format"><i class="fa fa-cloud"></i> <a href="#"><?php comments_popup_link('0 comment','one comment', '% comments');?></a></div>
			        
			    </div><!-- End Full meta -->
				<div class="inner-socials"><?php echo whiteboard64_pro_social_share(); ?></div>
			<?php
			endif; 
		?>

		<div class="entry-content">
	  		<?php if (has_post_thumbnail()) : ?>
	  			<div class="featured-image">
	  				<div class="image">
	    				<?php the_post_thumbnail('full', array('class' => 'center-block')); ?>
	    			</div>
	    		</div>
	  		<?php endif; ?>
 			
 			<?php
				the_content();

				wp_link_pages( array(
					'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'whiteboard64-pro' ),
					'after'  => '</div>',
				) );
			?>
		</div><!-- .entry-content -->

		<?php if ( get_edit_post_link() ) : ?>
			<footer class="entry-footer">
				<?php
					edit_post_link(
						sprintf(
							/* translators: %s: Name of current post */
							esc_html__( 'Edit %s', 'whiteboard64-pro' ),
							the_title( '<span class="screen-reader-text">"', '"</span>', false )
						),
						'<span class="edit-link">',
						'</span>'
					);
				?>
			</footer><!-- .entry-footer -->
		<?php endif; ?>

		<?php 
		    $show_authorinfo_in_post = get_theme_mod('whiteboard64_pro_authorinfo_display' );
		    if ( $show_authorinfo_in_post) {?>
			<div class="post-author">
				<h2><i class="fa fa-user"></i> <?php esc_html_e( 'About Author', 'whiteboard64-pro' ); ?></h2>
				<div class="general-info col-md-6 col-sm-12">					
					<div class="img-responsive pull-left">
						<?php echo get_avatar( get_the_author_meta( 'ID' ), 40 ); ?>
					</div>
						
			        <div class="short-info">
			    		<div class="author-name"><?php echo get_the_author_meta( 'display_name'); ?></div>
			    		<?php echo get_the_author_meta('email'); ?><br>
			    		<?php the_author_meta('url'); ?>
			   			 
			  		</div>
				</div>

				<div class="details col-md-6 col-sm-12"> 
					<div class="row">             
						<p><?php echo get_the_author_meta( 'description'); ?></p>
					</div>
				</div>
			</div>  <!-- /.end of author -->		
		<?php }?> 

		<!-- Add Banner -->
		<?php if ( is_active_sidebar( 'innerpage2-ad-block' ) ) : ?>
			<?php dynamic_sidebar( 'innerpage2-ad-block' ); ?>
		<?php endif; ?>

	</div>
</article><!-- #post-## -->