<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Whiteboard64 Pro
 */

get_header(); ?>
	
	<div class="innerpage">
		<img src="<?php header_image(); ?>" class="header-image feaImg img-responsive center-block" />
	</div>
	
	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">
			<div class="container">

				<?php
				  	$class = 'col-md-12';
				  	$sidebar =  get_theme_mod('single_post_sidebar_position');
				   		if($sidebar != 'none'){
				      	$class = 'col-md-9';
				  	}
				?> 
				<?php
				  if ($sidebar == 'left'){			     
				      	get_sidebar('left');
				    }
				?>
				<div class="<?php echo $class;?> detail-content">	
					<?php
					while ( have_posts() ) : the_post();
						get_template_part( 'template-parts/content', 'single' );?>

						<?php 
						    $show_postnav_in_post = get_theme_mod('whiteboard64-pro_postnavi_display' );
						    if ( $show_postnav_in_post) {?>
							<div class="col-sm-12"> 
							    <?php the_post_navigation(); ?>  
							</div> <!-- /.end of col 12 -->
						<?php }?> 

						<?php 
					        $show_comment_in_post = get_theme_mod('whiteboard64-pro_comment_post_display' );
					        if ( $show_comment_in_post) {?>
					        <?php
								// If comments are open or we have at least one comment, load up the comment template.
								if ( comments_open() || get_comments_number() ) :
									comments_template();
								endif;
							?>
						<?php }?>

					<?php endwhile; // End of the loop.
					?>

					<div class="related-posts wow fadeInUp" data-wow-duration="2s">
						<h3><?php esc_html_e( 'Related Posts', 'whiteboard64-pro' ); ?></h3>
						<?php
			                $related = get_posts( array( 
			                    'category__in' => wp_get_post_categories($post->ID), 
			                    'numberposts' => 6, 
			                    'post__not_in' => array($post->ID) 
			                    ) );
			                if( $related ) foreach( $related as $post ) {
			                setup_postdata($post); ?>

			                    <div class="col-xs-12 col-sm-12 col-md-4">
					            	<div class="row blog-details wow fadeInUp" data-wow-duration=".5s">
					              		<figure>
					                		<?php if (has_post_thumbnail()) : ?>
					                			<?php the_post_thumbnail('large'); ?>
					                		<?php else : ?>
					                  			<div class="no-img"><i class="fa fa-camera-retro fa-5x"></i></div>
					                		<?php endif; ?> 
					                		<div class="detail-date">
									        	<div class="month-day"><?php echo get_the_date('d M');?></div>
									        	<div class="year"><?php echo get_the_date('Y');?></div>
									    	</div>	                       
					                  
					                		<figcaption>
					                  			<div>    
								                    <a class="popular" href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a>
								                    <?php //echo whiteboard64_pro_content(18); ?>
								                    <a class="btn btn-primary" href="<?php the_permalink(); ?>" rel="bookmark"><?php esc_html_e( 'Full Details', 'whiteboard64-pro' ); ?></a>
					                  			</div>
					                		</figcaption>
					              		</figure> <!--figure end--> 
					            	</div> <!--blog-details end--> 
					          	</div>  <!--col-sm-4 end-->

			                <?php }
			                wp_reset_postdata(); 
			            ?>
					</div>
				</div>

				<?php  if ($sidebar == 'right'){             
				  	get_sidebar('right');            
				  	}
				?>

			</div>
		</main><!-- #main -->
	</div><!-- #primary -->

<?php
get_footer();