<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package Whiteboard64 Pro
 */

get_header(); ?>
	
	<div class="innerpage">
		<img src="<?php header_image(); ?>" class="header-image feaImg img-responsive center-block" />
	</div>
	
	<section id="primary" class="content-area">
		<main id="main" class="site-main" role="main">
			<div class="container">

				<?php
				  	$class = 'col-md-12';
				  	$sidebar =  get_theme_mod('search_page_sidebar_position');
				   		if($sidebar != 'none'){
				      	$class = 'col-md-9';
				  	}
				?> 
				<?php
				  if ($sidebar == 'left'){			     
				      	get_sidebar('left');
				    }
				?>
				<div class="<?php echo $class;?> detail-content">
					<?php
					if ( have_posts() ) : ?>

						<header class="page-header">
							<h1 class="page-title"><?php printf( esc_html__( 'Search Results for: %s', 'whiteboard64-pro' ), '<span>' . get_search_query() . '</span>' ); ?></h1>
						</header><!-- .page-header -->

						<?php
						/* Start the Loop */
						while ( have_posts() ) : the_post();

							/**
							 * Run the loop for the search to output the results.
							 * If you want to overload this in a child theme then include a file
							 * called content-search.php and that will be used instead.
							 */
							get_template_part( 'template-parts/content', 'search' );

						endwhile;

						the_posts_navigation();

					else :

						get_template_part( 'template-parts/content', 'none' );

					endif; ?>
				</div>

				<?php  if ($sidebar == 'right'){             
				  	get_sidebar('right');            
				  	}
				?>
				
			</div><!-- .container -->
		</main><!-- #main -->
	</section><!-- #primary -->

<?php
get_footer();