<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Whiteboard64 Pro
 */

get_header(); ?>
	<div class="innerpage">
		<img src="<?php header_image(); ?>" class="header-image feaImg img-responsive center-block" />
	</div>
	
	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">
			<div class="container">
				<?php
				  	$class = 'col-md-12';
				  	$sidebar =  get_theme_mod('single_page_sidebar_position');
				   		if($sidebar != 'none'){
				      	$class = 'col-md-9';
				  	}
				?> 
				<?php
				  if ($sidebar == 'left'){			     
				      	get_sidebar('left');
				    }
				?>
				<div class="<?php echo $class;?> detail-content">
					<?php
					while ( have_posts() ) : the_post();
						get_template_part( 'template-parts/content', 'page' );?>

						<?php 
					        $show_comment_in_post = get_theme_mod('whiteboard64-pro_comment_page_display' );
					        if ( $show_comment_in_post) {?>
					        <?php
								// If comments are open or we have at least one comment, load up the comment template.
								if ( comments_open() || get_comments_number() ) :
									comments_template();
								endif;
							?>
						<?php }?>

					<?php endwhile; // End of the loop.
					?>
				</div>

				<?php  if ($sidebar == 'right'){             
				  	get_sidebar('right');            
				  	}
				?>

			</div>
		</main><!-- #main -->
	</div><!-- #primary -->

<?php
get_footer();