<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Whiteboard64 Pro
 */

get_header(); ?>
	
	<div class="innerpage">
		<img src="<?php header_image(); ?>" class="header-image feaImg img-responsive center-block" />
	</div>
	
	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">
			<div class="container">

				<div class="col-sm-12 col-md-9">
					<?php
					if ( have_posts() ) :

						if ( is_home() && ! is_front_page() ) : ?>
							<header>
								<h1 class="page-title screen-reader-text"><?php single_post_title(); ?></h1>
							</header>

						<?php
						endif; ?>

						<div class="categoryposts-slider">
							<div id="carousel-whiteboard64-pro" class="carousel slide" data-ride="carousel">
								<div class="carousel-inner" role="listbox">								

						        	<?php
						        		$recentposts = get_posts('numberposts=4', 'paged=1', 'offset=1');
					   					foreach ($recentposts as $post) :
					       				setup_postdata($post); ?>
										<div class="item image5">
									    	<div class="wow fadeIn" data-wow-duration="2s">
									    		<?php the_post_thumbnail('full', array('class' => 'center-block')); ?>
										    </div>
										    <div class="carousel-caption wow slideInLeft" data-wow-duration="2s">
										    	<div class="container">
										      		<h2><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute();?>"><?php the_title();?></a></h2>
										      	</div>
										    </div>
									    </div><!-- .item -->
									<?php endforeach; ?>
						        	
								</div>
								<a class="left carousel-control" href="#carousel-whiteboard64-pro" data-slide="prev">
									<span class="icon-prev"></span>
								</a>
								<a class="right carousel-control" href="#carousel-whiteboard64-pro" data-slide="next">
									<span class="icon-next"></span>
								</a>
							</div> <!-- carousel slider -->
						</div> <!-- categoryposts-slider -->
						<div class="clearfix"></div>


						<?php 
						/* Start the Loop */
						while ( have_posts() ) : the_post();
							/*
							 * Include the Post-Format-specific template for the content.
							 * If you want to override this in a child theme, then include a file
							 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
							 */
							get_template_part( 'template-parts/content', get_post_format() );
						endwhile;
						the_posts_navigation();
					else :
						get_template_part( 'template-parts/content', 'none' );
					endif; ?>
				</div>					
				<?php get_sidebar(); ?>			

			</div>
		</main><!-- #main -->
	</div><!-- #primary -->

<?php
get_footer();