<?php
/**
 * Whiteboard64 Pro Theme Customizer
 *
 * @package Whiteboard64 Pro
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function whiteboard64_pro_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';


	$wp_customize->add_panel( 'theme_option', array(
        'priority' => 60,
        'title' => __( 'Whiteboard64 Theme Option', 'whiteboard64-pro' ),
        'description' => __( 'Lets configure your site with Whiteboard64 Theme Option', 'whiteboard64-pro' ),
    ));    


    /**********************************************/
    /********** SOCIAL ICON LINKS SECTION ***********/
    /**********************************************/

    $wp_customize->add_section('whiteboard64_pro_social_section',array(
        'priority' => 1,
        'title' => __('Social Media Section','whiteboard64-pro'),
        'description' => __('Customize Social Section in Homepage. Make sure that you have filled all the social links, blank field will not be displayed in site and it will be hidden by default.', 'whiteboard64-pro'),
        'panel' => 'theme_option'
    ));

    $wp_customize->add_setting('whiteboard64-pro_topbar_display',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'default' => true,
        'transport'  =>  'postMessage'
    ));
    $wp_customize->add_control(new WP_Customize_Control($wp_customize,'whiteboard64-pro_topbar_display',array(
        'label' => __('Show Topbar Section in Header? If Yes, click on checkbox and it will display Topbar Section with Date and Social Links.','whiteboard64-pro'),
        'section' => 'whiteboard64_pro_social_section',
        'settings' => 'whiteboard64-pro_topbar_display',
        'type'=> 'checkbox',
        ))
    );

    $wp_customize->add_setting(
        'facebook_link',
            array(
            'sanitize_callback' => 'esc_url_raw',
            'capability' => 'edit_theme_options',
            'default' => '',
    ));
    $wp_customize->add_control(
        'facebook_link',
            array(
            'label' => __('Facebook link URL', 'whiteboard64-pro'),
            'section' => 'whiteboard64_pro_social_section',
            'settings' => 'facebook_link',
            'type' => 'url',
    ));

    $wp_customize->add_setting(
        'twitter_link',
            array(
            'sanitize_callback' => 'esc_url_raw',
            'capability' => 'edit_theme_options',
            'default' => '',
    ));
    $wp_customize->add_control(
        'twitter_link',
            array(
            'label' => __('Twitter link URL', 'whiteboard64-pro'),
            'section' => 'whiteboard64_pro_social_section',
            'settings' => 'twitter_link',
            'type' => 'url',
    ));

    $wp_customize->add_setting(
        'googleplus_link',
            array(
            'sanitize_callback' => 'esc_url_raw',
            'capability' => 'edit_theme_options',
            'default' => '',
    ));
    $wp_customize->add_control(
        'googleplus_link',
            array(
            'label' => __('Googleplus link URL', 'whiteboard64-pro'),
            'section' => 'whiteboard64_pro_social_section',
            'settings' => 'googleplus_link',
            'type' => 'url',
    ));

    $wp_customize->add_setting(
        'linkedin_link',
            array(
            'sanitize_callback' => 'esc_url_raw',
            'capability' => 'edit_theme_options',
            'default' => '',
    ));
    $wp_customize->add_control(
        'linkedin_link',
            array(
            'label' => __('LinkedIn link URL', 'whiteboard64-pro'),
            'section' => 'whiteboard64_pro_social_section',
            'settings' => 'linkedin_link',
            'type' => 'url',
    ));

    $wp_customize->add_setting(
        'youtube_link',
            array(
            'sanitize_callback' => 'esc_url_raw',
            'capability' => 'edit_theme_options',
            'default' => '',
    ));      
    $wp_customize->add_control(
        'youtube_link',
            array(
            'label' => __('You Tube link URL', 'whiteboard64-pro'),
            'section' => 'whiteboard64_pro_social_section',
            'settings' => 'youtube_link',
            'type' => 'url',
    )); 

    $wp_customize->add_setting(
        'instagram_link',
            array(
            'sanitize_callback' => 'esc_url_raw',
            'capability' => 'edit_theme_options',
            'default' => '',
    ));
    $wp_customize->add_control(
        'instagram_link',
            array(
            'label' => __('Instagram link URL', 'whiteboard64-pro'),
            'section' => 'whiteboard64_pro_social_section',
            'settings' => 'instagram_link',
            'type' => 'url',
    ));

    $wp_customize->add_setting(
        'pinterest_link',
            array(
            'sanitize_callback' => 'esc_url_raw',
            'capability' => 'edit_theme_options',
            'default' => '',
    ));
    $wp_customize->add_control(
        'pinterest_link',
            array(
            'label' => __('Pinterest link URL', 'whiteboard64-pro'),
            'section' => 'whiteboard64_pro_social_section',
            'settings' => 'pinterest_link',
            'type' => 'url',
    ));

    $wp_customize->add_setting(
        'stumbleupon_link',
            array(
            'sanitize_callback' => 'esc_url_raw',
            'capability' => 'edit_theme_options',
            'default' => '',
    ));
    $wp_customize->add_control(
        'stumbleupon_link',
            array(
            'label' => __('Stumbleupon link URL', 'whiteboard64-pro'),
            'section' => 'whiteboard64_pro_social_section',
            'settings' => 'stumbleupon_link',
            'type' => 'url',
    ));

    $wp_customize->add_setting(
        'tumblr_link',
            array(
            'sanitize_callback' => 'esc_url_raw',
            'capability' => 'edit_theme_options',
            'default' => '',
    ));
    $wp_customize->add_control(
        'tumblr_link',
            array(
            'label' => __('Tumblr link URL', 'whiteboard64-pro'),
            'section' => 'whiteboard64_pro_social_section',
            'settings' => 'tumblr_link',
            'type' => 'url',
    ));

    $wp_customize->add_setting(
        'medium_link',
            array(
            'sanitize_callback' => 'esc_url_raw',
            'capability' => 'edit_theme_options',
            'default' => '',
    ));
    $wp_customize->add_control(
        'medium_link',
            array(
            'label' => __('Medium link URL', 'whiteboard64-pro'),
            'section' => 'whiteboard64_pro_social_section',
            'settings' => 'medium_link',
            'type' => 'url',
    ));



    /**********************************************/
    /****** HOMEPAGE SLIDER CATEGORY SECTION ******/
    /**********************************************/

    $wp_customize->add_section('whiteboard64_pro_slider_section',array(
        'priority' => 2,
        'title' => __('Slider Section','whiteboard64-pro'),
        'description' => __('Customize Slider Section in Homepage. Make sure that slider images must be minimum of 1400px width.','whiteboard64-pro'),
        'panel' => 'theme_option'
    ));

    //SLIDER CATEGORY SECTION
    $wp_customize->add_setting('slider_category_display',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_category',
        'default' => ''
    ));

    $wp_customize->add_control(new whiteboard64_Category_Dropdown_Custom_Control($wp_customize,'slider_category_display',array(
        'label' => __('Choose slider category to display in homepage','whiteboard64-pro'),
        'section' => 'whiteboard64_pro_slider_section',
        'settings' => 'slider_category_display',
        'type'=> 'dropdown-taxonomies',
        )  
    ));

    //SLIDER SLIDES NUMBER CONTROL
    $wp_customize->add_setting('slider_no',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'capability' => 'edit_theme_options',
        'default' => ''
    ));
    $wp_customize->add_control(new WP_Customize_Control($wp_customize,'slider_no',array(
          'label' => __('Enter your No. of Slider Posts in Slider Category to display','whiteboard64-pro'),
          'section' => 'whiteboard64_pro_slider_section',
          'settings' => 'slider_no',
          'type'=> 'text',
          ))
    );


    $wp_customize->add_setting('slider_one_height',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'default' => ''
    ));  
    $wp_customize->add_control(new WP_Customize_Control($wp_customize,'slider_one_height',array(
        'label' => __('Edit Frontpage1 Slider Height','whiteboard64-pro'),
        'section' => 'whiteboard64_pro_slider_section',
        'settings' => 'slider_one_height'
        )  
    )); 

    $wp_customize->add_setting('slider_two_height',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'default' => ''
    ));  
    $wp_customize->add_control(new WP_Customize_Control($wp_customize,'slider_two_height',array(
        'label' => __('Edit Frontpage2 Slider Height','whiteboard64-pro'),
        'section' => 'whiteboard64_pro_slider_section',
        'settings' => 'slider_two_height'
        )  
    ));

    $wp_customize->add_setting('slider_three_height',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'default' => ''
    ));  
    $wp_customize->add_control(new WP_Customize_Control($wp_customize,'slider_three_height',array(
        'label' => __('Edit Frontpage3 Slider Height','whiteboard64-pro'),
        'section' => 'whiteboard64_pro_slider_section',
        'settings' => 'slider_three_height'
        )  
    ));



    /**********************************************/
    /****** HOMEPAGE TABBED NEWS CATEGORY SECTION ******/
    /**********************************************/

    $wp_customize->add_section('whiteboard64_pro_tabbed_section',array(
        'priority' => 3,
        'title' => __('Tabbed News / Blog Section','whiteboard64-pro'),
        'description' => __('Customize News / Blog Section in Homepage. The maximum no. of tabs is 6.','whiteboard64-pro'),
        'panel' => 'theme_option'
    ));

    $wp_customize->add_setting('news1_category_display',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_category',
        'default' => ''
    ));
    $wp_customize->add_control(new whiteboard64_Category_Dropdown_Custom_Control($wp_customize,'news1_category_display',array(
        'label' => __('Choose 1st news / blog category to display in homepage','whiteboard64-pro'),
        'section' => 'whiteboard64_pro_tabbed_section',
        'settings' => 'news1_category_display',
        'type'=> 'dropdown-taxonomies',
        )  
    ));
    $wp_customize->add_setting('category1_no',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'capability' => 'edit_theme_options',
        'default' => ''
    ));
    $wp_customize->add_control(new WP_Customize_Control($wp_customize,'category1_no',array(
          'label' => __('Enter your No. of News Posts in 1st Category to display','whiteboard64-pro'),
          'section' => 'whiteboard64_pro_tabbed_section',
          'settings' => 'category1_no',
          'type'=> 'text',
          ))
    );



    $wp_customize->add_setting('news2_category_display',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_category',
        'default' => ''
    ));
    $wp_customize->add_control(new whiteboard64_Category_Dropdown_Custom_Control($wp_customize,'news2_category_display',array(
        'label' => __('Choose 2nd news / blog category to display in homepage','whiteboard64-pro'),
        'section' => 'whiteboard64_pro_tabbed_section',
        'settings' => 'news2_category_display',
        'type'=> 'dropdown-taxonomies',
        )  
    ));
    $wp_customize->add_setting('category2_no',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'capability' => 'edit_theme_options',
        'default' => ''
    ));
    $wp_customize->add_control(new WP_Customize_Control($wp_customize,'category2_no',array(
          'label' => __('Enter your No. of News Posts in 2nd Category to display','whiteboard64-pro'),
          'section' => 'whiteboard64_pro_tabbed_section',
          'settings' => 'category2_no',
          'type'=> 'text',
          ))
    );



    $wp_customize->add_setting('news3_category_display',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_category',
        'default' => ''
    ));
    $wp_customize->add_control(new whiteboard64_Category_Dropdown_Custom_Control($wp_customize,'news3_category_display',array(
        'label' => __('Choose 3rd news / blog category to display in homepage','whiteboard64-pro'),
        'section' => 'whiteboard64_pro_tabbed_section',
        'settings' => 'news3_category_display',
        'type'=> 'dropdown-taxonomies',
        )  
    ));
    $wp_customize->add_setting('category3_no',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'capability' => 'edit_theme_options',
        'default' => ''
    ));
    $wp_customize->add_control(new WP_Customize_Control($wp_customize,'category3_no',array(
          'label' => __('Enter your No. of News Posts in 3rd Categoryto display','whiteboard64-pro'),
          'section' => 'whiteboard64_pro_tabbed_section',
          'settings' => 'category3_no',
          'type'=> 'text',
          ))
    );


    $wp_customize->add_setting('news4_category_display',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_category',
        'default' => ''
    ));
    $wp_customize->add_control(new whiteboard64_Category_Dropdown_Custom_Control($wp_customize,'news4_category_display',array(
        'label' => __('Choose 4th news / blog category to display in homepage','whiteboard64-pro'),
        'section' => 'whiteboard64_pro_tabbed_section',
        'settings' => 'news4_category_display',
        'type'=> 'dropdown-taxonomies',
        )  
    ));
    $wp_customize->add_setting('category4_no',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'capability' => 'edit_theme_options',
        'default' => ''
    ));
    $wp_customize->add_control(new WP_Customize_Control($wp_customize,'category4_no',array(
          'label' => __('Enter your No. of News Posts in 4th Categoryto display','whiteboard64-pro'),
          'section' => 'whiteboard64_pro_tabbed_section',
          'settings' => 'category4_no',
          'type'=> 'text',
          ))
    );


    $wp_customize->add_setting('news5_category_display',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_category',
        'default' => ''
    ));
    $wp_customize->add_control(new whiteboard64_Category_Dropdown_Custom_Control($wp_customize,'news5_category_display',array(
        'label' => __('Choose 5th news / blog category to display in homepage','whiteboard64-pro'),
        'section' => 'whiteboard64_pro_tabbed_section',
        'settings' => 'news5_category_display',
        'type'=> 'dropdown-taxonomies',
        )  
    ));
    $wp_customize->add_setting('category5_no',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'capability' => 'edit_theme_options',
        'default' => ''
    ));
    $wp_customize->add_control(new WP_Customize_Control($wp_customize,'category5_no',array(
          'label' => __('Enter your No. of News Posts in 5th Categoryto display','whiteboard64-pro'),
          'section' => 'whiteboard64_pro_tabbed_section',
          'settings' => 'category5_no',
          'type'=> 'text',
          ))
    );


    $wp_customize->add_setting('news6_category_display',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'capability' => 'edit_theme_options',
        'default' => ''
    ));    
    $wp_customize->add_control(new whiteboard64_Category_Dropdown_Custom_Control($wp_customize,'news6_category_display',array(
        'label' => __('Choose 6th news / blog category to display in homepage','whiteboard64-pro'),
        'section' => 'whiteboard64_pro_tabbed_section',
        'settings' => 'news6_category_display',
        'type'=> 'dropdown-taxonomies',
        )  
    ));
    $wp_customize->add_setting('category6_no',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'capability' => 'edit_theme_options',
        'default' => ''
    ));
    $wp_customize->add_control(new WP_Customize_Control($wp_customize,'category6_no',array(
          'label' => __('Enter your No. of News Posts in 6th Category to display','whiteboard64-pro'),
          'section' => 'whiteboard64_pro_tabbed_section',
          'settings' => 'category6_no',
          'type'=> 'text',
          ))
    );


    /**********************************************/
    /*************** NEWS CAROUSEL SECTION *****************/
    /**********************************************/      

    $wp_customize->add_section('carousel_section',array(
        'priority' => 40,
        'title' => __('News Carousel Section','whiteboard64-pro'),
        'description' => __('Customize your news carousel Settings here.', 'whiteboard64-pro'),
        'panel' => 'theme_option',
    ));

    $wp_customize->add_setting('news_carousel_display',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'default' => ''
    )); 
    $wp_customize->add_control(new WP_Customize_Control($wp_customize,'news_carousel_display',array(
        'label' => __('Show News Carousel Section in Frontpage? If checked, it will be displayed and if unchecked, it will be hidden.','whiteboard64-pro'),
        'section' => 'carousel_section',
        'settings' => 'news_carousel_display',
        'type'=> 'checkbox',
        ))
    );

    $wp_customize->add_setting('popular_title', array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'default' => ''
    ));
    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'popular_title', array( 
        'label' => __( 'News Carousel Heading Title', 'whiteboard64-pro' ),
        'section' => 'carousel_section',
        'settings' => 'popular_title', 
        'type'     => 'text', 
    )));

    $wp_customize->add_setting('news7_category_display',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'capability' => 'edit_theme_options',
        'default' => ''
    ));
    $wp_customize->add_control(new whiteboard64_Category_Dropdown_Custom_Control($wp_customize,'news7_category_display',array(
        'label' => __('Choose news carousel category to display in homepage','whiteboard64-pro'),
        'section' => 'carousel_section',
        'settings' => 'news7_category_display',
        'type'=> 'dropdown-taxonomies',
        )  
    ));

    $wp_customize->add_setting('category7_no',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'capability' => 'edit_theme_options',
        'default' => ''
    ));
    $wp_customize->add_control(new WP_Customize_Control($wp_customize,'category7_no',array(
          'label' => __('Enter your No. of Posts in News Carousel Category to display','whiteboard64-pro'),
          'section' => 'carousel_section',
          'settings' => 'category7_no',
          'type'=> 'text',
          ))
    );


    /**********************************************/
    /*************** COLORS SECTION *****************/
    /**********************************************/      

    $wp_customize->add_section('color_settings',array(
        'priority' => 40,
        'title' => __('Colors Settings','whiteboard64-pro'),
        'description' => __('Customize your Colors Settings for Top Header, Footer and Menus here.', 'whiteboard64-pro'),
        'panel' => 'theme_option',
    ));


    /**************************************************************/
    /*************** TOP HEADER BACKGOUND SECTION *****************/ 
    $wp_customize->add_setting('header_color',array(
        'sanitize_callback' => 'sanitize_hex_color',
        'default' => ''
    )); 
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize,'header_color',array(
        'label' => __('Choose your Top Header Background Color. By default, it will be black.','whiteboard64-pro'),
        'section' => 'color_settings',
        'settings' => 'header_color'
        )  
    ));


    /*****************************************************************/
    /*************** FOOTER BACKGROUND COLOR SECTION *****************/ 
    $wp_customize->add_setting('footer_color',array(
        'sanitize_callback' => 'sanitize_hex_color',
        'default' => ''
    )); 
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize,'footer_color',array(
        'label' => __('Choose your Footer Background Color. By default, it will be black.','whiteboard64-pro'),
        'section' => 'color_settings',
        'settings' => 'footer_color'
        )  
    )); 


    /*********************************************************************/
    /*************** MENU ACTIVE AND HOVER COLOR SECTION *****************/ 
    $wp_customize->add_setting('menu_color',array(
        'sanitize_callback' => 'sanitize_hex_color',
        'default' => ''
    ));  
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize,'menu_color',array(
        'label' => __('Choose your Menu Active Background Color. By default, it will be black.','whiteboard64-pro'),
        'section' => 'color_settings',
        'settings' => 'menu_color'
        )  
    )); 


    $wp_customize->add_setting('menu_color_hover',array(
        'sanitize_callback' => 'sanitize_hex_color',
        'default' => ''
    ));  
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize,'menu_color_hover',array(
        'label' => __('Choose your Menu Hover Background Color. By default, it will be black.','whiteboard64-pro'),
        'section' => 'color_settings',
        'settings' => 'menu_color_hover'
        )  
    )); 



    /**********************************************/
    /*************** EXTRA SECTION ***************/
    /**********************************************/
    $wp_customize->add_section(
        'extra_section',
          array(
            'title' => __('Extra Settings','whiteboard64-pro'),
            'description' => __('This section includes Innerpage Settings for Author Info and Post Navigation enable / disable option.','whiteboard64-pro'),
            'panel' => 'theme_option'
        )
    );


    $wp_customize->add_setting('whiteboard64-pro_sidebar_socials_display',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'default' => ''
    ));
    $wp_customize->add_control(new WP_Customize_Control($wp_customize,'whiteboard64-pro_sidebar_socials_display',array(
        'label' => __('Show Social Icons Section in Sidebar? If Yes, only FaceBook, Twitter, Google+, LinkedIn and YouTube will be displayed in Sidebar with Animation.','whiteboard64-pro'),
        'section' => 'extra_section',
        'settings' => 'whiteboard64-pro_sidebar_socials_display',
        'type'=> 'checkbox',
        ))
    );

    $wp_customize->add_setting('whiteboard64_socials_display',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'default' => ''
    ));
    $wp_customize->add_control(new WP_Customize_Control($wp_customize,'whiteboard64_socials_display',array(
        'label' => __('Show Social Icons Section in Footer?','whiteboard64-pro'),
        'section' => 'extra_section',
        'settings' => 'whiteboard64_socials_display',
        'type'=> 'checkbox',
        ))
    );


    $wp_customize->add_setting('whiteboard64-pro_categorysliderposts_display',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'default' => ''
    ));
    $wp_customize->add_control(new WP_Customize_Control($wp_customize,'whiteboard64-pro_categorysliderposts_display',array(
        'label' => __('Show Category Posts Slider in Archive / Category Page?','whiteboard64-pro'),
        'section' => 'extra_section',
        'settings' => 'whiteboard64-pro_categorysliderposts_display',
        'type'=> 'checkbox',
        ))
    );


    $wp_customize->add_setting('whiteboard64_comment_page_display',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'default' => ''
    ));
    $wp_customize->add_control(new WP_Customize_Control($wp_customize,'whiteboard64_comment_page_display',array(
        'label' => __('Show Comment Form in Page?','whiteboard64-pro'),
        'section' => 'extra_section',
        'settings' => 'whiteboard64_comment_page_display',
        'type'=> 'checkbox',
        ))
    );


    $wp_customize->add_setting('whiteboard64_comment_post_display',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'default' => ''
    ));
    $wp_customize->add_control(new WP_Customize_Control($wp_customize,'whiteboard64_comment_post_display',array(
        'label' => __('Show Comment Form in Post?','whiteboard64-pro'),
        'section' => 'extra_section',
        'settings' => 'whiteboard64_comment_post_display',
        'type'=> 'checkbox',
        ))
    );


    $wp_customize->add_setting('whiteboard64_authorinfo_display',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'default' => ''
    ));
    $wp_customize->add_control(new WP_Customize_Control($wp_customize,'whiteboard64_authorinfo_display',array(
        'label' => __('Show Author Info in Post','whiteboard64-pro'),
        'section' => 'extra_section',
        'settings' => 'whiteboard64_authorinfo_display',
        'type'=> 'checkbox',
        ))
    );


    $wp_customize->add_setting('whiteboard64_postnavi_display',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'default' => ''
    ));
    $wp_customize->add_control(new WP_Customize_Control($wp_customize,'whiteboard64_postnavi_display',array(
        'label' => __('Show Post Navigation in Post','whiteboard64-pro'),
        'section' => 'extra_section',
        'settings' => 'whiteboard64_postnavi_display',
        'type'=> 'checkbox',
        ))
    );





    /**********************************************/
    /*************** FOOTER SECTION ***************/
    /**********************************************/
    $wp_customize->add_section(
        'footer_section',
          array(
            'title' => __('Footer Settings','whiteboard64-pro'),
            'description' => __('This section includes Footer Settings for footer credits and desclaimer enable / disable option.','whiteboard64-pro'),
            'panel' => 'theme_option'
        )
    );


    $wp_customize->add_setting('whiteboard64-pro_footer_credits_display',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'default' => true,
        'transport'  =>  'postMessage'
    ));
    $wp_customize->add_control(new WP_Customize_Control($wp_customize,'whiteboard64-pro_footer_credits_display',array(
        'label' => __('Show Footer Credits Section in Footer? If Yes, click on checkbox and it will display footer credits links of Power by WordPress site link and Theme author site link.','whiteboard64-pro'),
        'section' => 'footer_section',
        'settings' => 'whiteboard64-pro_footer_credits_display',
        'type'=> 'checkbox',
        ))
    );


    $wp_customize->add_setting('whiteboard64-pro_footer_disclaimer_display',array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'default' => true,
        'transport'  =>  'postMessage'
    ));
    $wp_customize->add_control(new WP_Customize_Control($wp_customize,'whiteboard64-pro_footer_disclaimer_display',array(
        'label' => __('Show Footer Disclaimer Section in Footer? If Yes, click on checkbox and it will display footer desclaimer as needed. You can type your own site disclaimer here.','whiteboard64-pro'),
        'section' => 'footer_section',
        'settings' => 'whiteboard64-pro_footer_disclaimer_display',
        'type'=> 'checkbox',
        ))
    );


    $wp_customize->add_setting('disclaimer_title', array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'default' => true,
        'transport'  =>  'postMessage'
    ));
    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'disclaimer_title', array( 
        'label' => __( 'Type your Footer Disclaimer here', 'whiteboard64-pro' ),
        'section' => 'footer_section',
        'settings' => 'disclaimer_title', 
        'type'     => 'text', 
    )));





    /**********************************************/
    /***** ADJUSTMENT OF SIDEBAR POSITION SECTION *****/
    /**********************************************/     
    $wp_customize->add_panel( 'layout', array(
        'priority' => 70,
        'title' => __( 'Theme Sidebar Layout', 'whiteboard64-pro' ),
        'description' => __( 'Customize your Theme Sidebar Layout Position here. Theme has Left Sidebar, Right Sidebar and No Sidebar Section for Pages, Posts, Archive Category, Search and 404 Not Found Sections.', 'whiteboard64-pro' ),
    ));

    $wp_customize->add_section('category_sidebar' , array(
        'title' => __('Archive Category Sidebar','whiteboard64-pro'),
        'panel' => 'layout'
    ));
    $wp_customize->add_setting('category_sidebar_position', array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'default' => ''
    ));
    $wp_customize->add_control('category_sidebar_position', array(
        'label'      => __('Category Sidebar position', 'whiteboard64-pro'),
        'section'    => 'category_sidebar',
        'settings'   => 'category_sidebar_position',
        'type'       => 'radio',
        'choices'    => array(
            'none'   => __('No Sidebar','whiteboard64-pro'),
            'left'   => __('Left Sidebar','whiteboard64-pro'),
            'right'  => __('Right Sidebar','whiteboard64-pro'),
        ),
    ));


    /**********************************************/
    /********** SINGLE POST SIDEBAR SECTION ***********/
    /**********************************************/
    $wp_customize->add_section('single_post_sidebar' , array(
        'title' => __('Single Post Sidebar','whiteboard64-pro'),
        'panel' => 'layout'
    ));
    $wp_customize->add_setting('single_post_sidebar_position', array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'default' => ''
    ));
    $wp_customize->add_control('single_post_sidebar_position', array(
        'label'      => __('Single Post Sidebar position', 'whiteboard64-pro'),
        'section'    => 'single_post_sidebar',
        'settings'   => 'single_post_sidebar_position',
        'type'       => 'radio',
        'choices'    => array(
            'none'   => __('No Sidebar','whiteboard64-pro'),
            'left'   => __('Left Sidebar','whiteboard64-pro'),
            'right'  => __('Right Sidebar','whiteboard64-pro'),
        ),
    ));


    /**********************************************/
    /********** SINGLE PAGE SIDEBAR SECTION ***********/
    /**********************************************/
    $wp_customize->add_section('single_page_sidebar' , array(
        'title' => __('Single Page Sidebar','whiteboard64-pro'),
        'panel' => 'layout'
    ));
    $wp_customize->add_setting('single_page_sidebar_position', array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'default' => ''
    ));
    $wp_customize->add_control('single_page_sidebar_position', array(
        'label'      => __('Single Page Sidebar position', 'whiteboard64-pro'),
        'section'    => 'single_page_sidebar',
        'settings'   => 'single_page_sidebar_position',
        'type'       => 'radio',
        'choices'    => array(
            'none'   => __('No Sidebar','whiteboard64-pro'),
            'left'   => __('Left Sidebar','whiteboard64-pro'),
            'right'  => __('Right Sidebar','whiteboard64-pro'),
        ),
    ));


    /**********************************************/
    /******** SEARCH PAGE SIDEBAR SECTION *********/
    /**********************************************/  
    $wp_customize->add_section('search_page_sidebar' , array(
        'title' => __('Search Page Sidebar','whiteboard64-pro'),
        'panel' => 'layout'
    ));
    $wp_customize->add_setting('search_page_sidebar_position', array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'default' => ''
    ));
    $wp_customize->add_control('search_page_sidebar_position', array(
        'label'      => __('Search Page Sidebar position', 'whiteboard64-pro'),
        'section'    => 'search_page_sidebar',
        'settings'   => 'search_page_sidebar_position',
        'type'       => 'radio',
        'choices'    => array(
            'none'   => __('No Sidebar','whiteboard64-pro'),
            'left'   => __('Left Sidebar','whiteboard64-pro'),
            'right'  => __('Right Sidebar','whiteboard64-pro'),
        ),
    ));



    /**********************************************/
    /******** PAGE NOT FOUND SIDEBAR SECTION *********/
    /**********************************************/ 
    $wp_customize->add_section('page_not_found_sidebar' , array(
        'title' => __('Page Not Found Sidebar','whiteboard64-pro'),
        'panel' => 'layout'
    ));
    $wp_customize->add_setting('page_not_found_sidebar_position', array(
        'sanitize_callback' => 'whiteboard64_pro_sanitize_text',
        'default' => ''
    ));
    $wp_customize->add_control('page_not_found_sidebar_position', array(
        'label'      => __('Page Not Found Sidebar position', 'whiteboard64-pro'),
        'section'    => 'page_not_found_sidebar',
        'settings'   => 'page_not_found_sidebar_position',
        'type'       => 'radio',
        'choices'    => array(
            'none'   => __('No Sidebar','whiteboard64-pro'),
            'left'   => __('Left Sidebar','whiteboard64-pro'),
            'right'  => __('Right Sidebar','whiteboard64-pro'),
        ),
    )); 






}
add_action( 'customize_register', 'whiteboard64_pro_customize_register' );

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function whiteboard64_pro_customize_preview_js() {
	wp_enqueue_script( 'whiteboard64_pro_customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20170105', true );
}
add_action( 'customize_preview_init', 'whiteboard64_pro_customize_preview_js' );


function whiteboard64_pro_sanitize_text( $input ) {
    return wp_kses_post( force_balance_tags( $input ) );
}

function whiteboard64_pro_sanitize_category($input){
  $output=intval($input);
  return $output;
}



/********************************************************/
/******** WHITEBOARD64 PRO TOP HEADER COLOR SECTION *********/
/********************************************************/ 
function whiteboard64_pro_header_color_options() {
  $header_color = get_theme_mod( 'header_color' ); 
  
  if ( $header_color != '#111111' ) :
  ?>
    <style type="text/css">
      .top-header {
        background: <?php echo $header_color; ?>;
      }
    </style>
  <?php
  endif;
}
add_action( 'wp_head', 'whiteboard64_pro_header_color_options' );


/********************************************************/
/***** WHITEBOARD64 PRO FOOTER BACKGROUND COLOR SECTION *****/
/********************************************************/ 
function whiteboard64_pro_footer_color_options() {
  $footer_color = get_theme_mod( 'footer_color' ); 
  
  if ( $footer_color != '#111111' ) :
  ?>
    <style type="text/css">
      footer {
        background: <?php echo $footer_color; ?>;
      }
    </style>
  <?php
  endif;
}
add_action( 'wp_head', 'whiteboard64_pro_footer_color_options' );


/********************************************************/
/******** WHITEBOARD64 PRO MENU ACTIVE COLOR SECTION ********/
/********************************************************/ 
function whiteboard64_pro_menu_color_options() {
    $menu_color = get_theme_mod( 'menu_color' ); 
  
    if ( $menu_color != '#111111' ) :
    ?>
    <style type="text/css">
        .navbar-default .navbar-nav > .active > a, 
        .navbar-default .navbar-nav > .active > a:hover, 
        .navbar-default .navbar-nav > .active > a:focus {
            background: <?php echo $menu_color; ?> !important;
        }
    </style>
    <?php
    endif;
}
add_action( 'wp_head', 'whiteboard64_pro_menu_color_options' );


/********************************************************/
/******** WHITEBOARD64 PRO MENU HOVER COLOR SECTION *********/
/********************************************************/ 
function whiteboard64_pro_menu_color_hover_options() {
    $menu_color_hover = get_theme_mod( 'menu_color_hover' ); 
  
    if ( $menu_color_hover != '#111111' ) :
    ?>
    <style type="text/css">
        .navbar-default .navbar-nav > li > a:hover, 
        .navbar-default .navbar-nav > li > a:focus{
            background: <?php echo $menu_color_hover; ?> !important;
        }
    </style>
    <?php
    endif;
}
add_action( 'wp_head', 'whiteboard64_pro_menu_color_hover_options' );


/********************************************************/
/******** WHITEBOARD64 PRO HP1 SLIDER HEIGHT SECTION ********/
/********************************************************/ 
function whiteboard64_pro_frontpage_slider1_options() {
    $slider_one_height = get_theme_mod( 'slider_one_height' );   
    if ( $slider_one_height != '401px' ) :
    ?>
    <style type="text/css">
        .item.image1 {
            max-height: <?php echo $slider_one_height; ?> !important;
            overflow: hidden;
        }
    </style>
    <?php
    endif;
}
add_action( 'wp_head', 'whiteboard64_pro_frontpage_slider1_options' );


/********************************************************/
/******** WHITEBOARD64 PRO HP2 SLIDER HEIGHT SECTION ********/
/********************************************************/ 
function whiteboard64_pro_frontpage_slider2_options() {
    $slider_two_height = get_theme_mod( 'slider_two_height' );   
    if ( $slider_two_height != '401px' ) :
    ?>
    <style type="text/css">
        .item.image2 {
            max-height: <?php echo $slider_two_height; ?> !important;
            overflow: hidden;
        }
    </style>
    <?php
    endif;
}
add_action( 'wp_head', 'whiteboard64_pro_frontpage_slider2_options' );


/********************************************************/
/******** WHITEBOARD64 PRO HP3 SLIDER HEIGHT SECTION ********/
/********************************************************/ 
function whiteboard64_pro_frontpage_slider3_options() {
    $slider_three_height = get_theme_mod( 'slider_three_height' );   
    if ( $slider_three_height != '381px' ) :
    ?>
    <style type="text/css">
        .item.image3  {
            max-height: <?php echo $slider_three_height; ?> !important;
            overflow: hidden;
        }
    </style>
    <?php
    endif;
}
add_action( 'wp_head', 'whiteboard64_pro_frontpage_slider3_options' );