<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Whiteboard64 Pro
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<link rel="profile" href="http://gmpg.org/xfn/11">

		<?php wp_head(); ?>
	</head>

	<body <?php body_class(); ?>>

		<?php 
		$show_header_topbar = get_theme_mod('whiteboard64-pro_topbar_display' );
		if ( $show_header_topbar) {?>

		<div class="top-header">
			<div class="container">

				<div class="col-sm-12 col-md-6 text-left top-date">
					<?php echo date_i18n("l jS \of F Y"); ?>
				</div>

				<div class="col-sm-12 col-md-6 socialicons">
					<ul class="socials text-right"> 
						<?php 	               	
		               	$facebook =  esc_url(get_theme_mod('facebook_link'));
		                $twitter = esc_url(get_theme_mod('twitter_link'));
		                $googleplus = esc_url(get_theme_mod('googleplus_link'));
		                $linkedin = esc_url(get_theme_mod('linkedin_link'));
		                $youtube = esc_url(get_theme_mod('youtube_link')); 

		                $instagram = esc_url(get_theme_mod('instagram_link'));
		                $pinterest = esc_url(get_theme_mod('pinterest_link'));
		                $stumbleupon = esc_url(get_theme_mod('stumbleupon_link'));
		                $tumblr = esc_url(get_theme_mod('tumblr_link'));
		                $medium = esc_url(get_theme_mod('medium_link'));
		                
		                if($facebook){?>
		                <li><a target="_blank" href="<?php echo esc_url($facebook); ?>"><i class="fa fa-facebook"></i></a></li>
		                <?php }
		                if($twitter){?>
		                <li><a target="_blank" href="<?php echo esc_url($twitter); ?>"><i class="fa fa-twitter"></i></a></li>
		                <?php }
		                if($googleplus){?>
		                <li><a target="_blank" href="<?php echo esc_url($googleplus); ?>"><i class="fa fa-google-plus"></i></a></li>
		                <?php }
		                if($linkedin){?>
		                <li><a target="_blank" href="<?php echo esc_url($linkedin); ?>"><i class="fa fa-linkedin"></i></a></li>
		                <?php }
		                if($youtube){?>
		                <li><a target="_blank" href="<?php echo esc_url($youtube); ?>"><i class="fa fa-youtube"></i></a></li>
		                <?php }

		                if($instagram){?>
		                <li><a target="_blank" href="<?php echo esc_url($instagram); ?>"><i class="fa fa-instagram"></i></a></li>
		                <?php }
		                if($pinterest){?>
		                <li><a target="_blank" href="<?php echo esc_url($pinterest); ?>"><i class="fa fa-pinterest"></i></a></li>
		                <?php }
		                if($stumbleupon){?>
		                <li><a target="_blank" href="<?php echo esc_url($stumbleupon); ?>"><i class="fa fa-stumbleupon"></i></a></li>
		                <?php }
		                if($tumblr){?>
		                <li><a target="_blank" href="<?php echo esc_url($tumblr); ?>"><i class="fa fa-tumblr"></i></a></li>
		                <?php }
		                if($medium){?>
		                <li><a target="_blank" href="<?php echo esc_url($medium); ?>"><i class="fa fa-medium"></i></a></li>
		                <?php }
		            	?> 
					</ul>
				</div>
			</div><!-- .container -->
		</div><!-- .top-header -->
		<?php }?>




		<div class="header">
			<div class="container">

				<div class="col-sm-12 col-md-12 site-branding">
					<?php if (function_exists('whiteboard64_pro_the_custom_logo')) : ?>	                            
		                <?php echo '<div class="site-logo">'; ?>
		    				<?php whiteboard64_pro_the_custom_logo(); ?>
		    			<?php echo '</div>'; ?> 
		            <?php else : ?>
		            	<h1 class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a></h1>
						<h2 class="site-description"><?php bloginfo( 'description' ); ?></h2>
					<?php endif; ?>
				</div><!-- .site-branding -->

				<?php if ( is_active_sidebar( 'header-ad-block' ) ) : ?>
					<div class="col-sm-12 col-md-12 top-ads text-left">
						<div class="img-responsive center-block">
						<?php dynamic_sidebar( 'header-ad-block' ); ?>
						</div>
					</div>
				<?php endif; ?>

			</div><!-- .container -->
		</div><!-- .header -->

		<div class="topmenu">
			<div class="container">		
				<div class="col-sm-11 col-md-11">	
					<nav class="navbar navbar-default">
	    			<div class="theme-nav pull-left">
	    				<div class="navbar navbar-default" role="navigation">
							<div class="navbar-header">
								<button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
							      	<span class="sr-only"><?php _e('Toggle navigation','whiteboard64-pro'); ?></span>
							      	<span class="icon-bar"></span>
							      	<span class="icon-bar"></span>
							      	<span class="icon-bar"></span>
								</button>
							</div>							

							<div class="navbar-collapse collapse"> 
		                        <?php
						            wp_nav_menu( array(
						                'menu'              => 'primary',
						                'theme_location'    => 'primary',
						                'depth'             => 4,
						                'container'         => 'div',
						                'container_class'   => 'collapse navbar-collapse',
						        		'container_id'      => 'bs-example-navbar-collapse-1',
						                'menu_class'        => 'nav navbar-nav',
						                'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
						                'walker'            => new wp_bootstrap_navwalker())
						            );
						        ?>
						    </div>
		                </div>      			
		    		</div>
		  		</nav> <!--navigation end-->		
	            </div><!-- .col-md-11 -->

	            <div class="col-sm-1 col-md-1 header-search text-right">
	            	<span class="top-search header-search">
                        <button type="button" class="btn navbar-search-theme" data-toggle="modal" data-target="#myModal">
                            <i class="fa fa-search"></i>
                        </button>
                        <!-- Modal -->
                        <div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-body">
                                        <form method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                                            <input type="text" class="form-control" placeholder="Type Something to search and hit enter key" value="<?php echo get_search_query(); ?>" name="s">
                                        </form>
                                    </div> <!-- end of modal-body -->
                                </div> <!-- end of modal-content -->
                            </div> <!-- end of modal-dialog -->
                        </div> <!-- end of modal-fade -->
                    </span>
	            </div>

			</div><!-- .container -->
		</div>