<?php
/**
 * Template Name: Front Page4
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Whiteboard64 Pro
 */

get_header(); ?>
	<div class="frontpage">
		<div class="col-sm-12 col-md-6">
			<div class="row">
				<div id="carousel-whiteboard64-pro" class="carousel slide" data-ride="carousel">
					<div class="carousel-inner" role="listbox">
						<?php
							$cid = get_theme_mod('slider_category_display');
							$nid = get_theme_mod('slider_no');
							$category_link = get_category_link($cid);
							$whiteboard64_cat = get_category($cid);
							if ($whiteboard64_cat) {
			        	?>

			        	<?php
				            $args = array(
				              'posts_per_page' => $nid,
				              'paged' => 1,
				              'cat' => $cid
				            );
				            $loop = new WP_Query($args);
				            
				            $cn = 0;
				            if ($loop->have_posts()) :  while ($loop->have_posts()) : $loop->the_post();$cn++;
				        ?>

					    <div class="item image3">
					    	<div class="wow fadeIn" data-wow-duration="2s">
						    	<?php the_post_thumbnail('full', array('class' => 'center-block')); ?>
						    </div>
						    <div class="carousel-caption wow slideInLeft" data-wow-duration="2s">
						    	<div class="container">
						      		<h2><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute();?>"><?php the_title();?></a></h2>
						      		<?php echo whiteboard64_pro_content(15); ?>
						      	</div>
						    </div>
					    </div><!-- .item -->

					    <?php                 
			      			endwhile;
			      				wp_reset_postdata();  
			      			endif;                             
			    				}
			    		?>
					</div>
					<a class="left carousel-control" href="#carousel-whiteboard64-pro" data-slide="prev">
						<span class="icon-prev"></span>
					</a>
					<a class="right carousel-control" href="#carousel-whiteboard64-pro" data-slide="next">
						<span class="icon-next"></span>
					</a>
				</div> <!-- carousel slider -->
			</div>
		</div>





		<div class="col-sm-12 col-md-6">
			<div class="row">
				<div class="recent-posts">	
					<?php
					   	$recentposts = get_posts('numberposts=4', 'paged=1', 'offset=1');
					   	foreach ($recentposts as $post) :
					       	setup_postdata($post); ?>
					   		<div class="col-xs-12 col-sm-12 col-md-6">
					   			<div class="row">
					            	<div class="recent-post wow fadeInUp" data-wow-duration=".5s">
					              		<figure>
					                		<?php if (has_post_thumbnail()) : ?>
					                			<?php the_post_thumbnail('full'); ?>
					                		<?php else : ?>
					                  			<div class="no-img"><i class="fa fa-camera-retro fa-5x"></i></div>
					                		<?php endif; ?> 
					                		<div class="detail-date">
									        	<div class="month-day"><?php echo get_the_date('d M');?></div>
									        	<div class="year"><?php echo get_the_date('Y');?></div>
									    	</div>
					                		<figcaption>
					                  			<div>    
								                    <a class="popular" href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a>
								                    <?php echo whiteboard64_pro_content(18); ?>
								                    <a class="btn btn-primary" href="<?php the_permalink(); ?>" rel="bookmark"><?php esc_attr( 'Full Details', 'whiteboard64-pro' ); ?></a>
					                  			</div>
					                		</figcaption>
					              		</figure> <!--figure end--> 
					            	</div> <!--blog-details end--> 
					            </div>
				          	</div>  <!--col-sm-4 end-->				   	
						<?php endforeach; 
					?>
				</div>
			</div>
		</div>
	</div>





	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">
			<div class="container">

				<div class="news-tab">
					<div class="col-xs-12 col-sm-12">
		        		<div class="row">
		        			
							<?php
				                $cid = get_theme_mod('news1_category_display');
				                $whiteboard64_cat = get_category($cid);
				                if ($whiteboard64_cat) {
			                ?>
			                <div class="col-sm-12 category-title">
			                	<h3><?php echo ''.esc_attr( get_cat_name( get_theme_mod('news1_category_display') ) ).''?></h3>
		        				<div class="view-category text-right">
		        					<a href="<?php echo get_category_link($cid); ?>">View All</a>
		        				</div>
		        			</div>

			                <?php
			                  	$args = array(
			                    'posts_per_page' => 1,
			                    'paged' => 1,
			                    'cat' => $cid
			                  	);
			                  	$loop = new WP_Query($args);
			                  
			                  	$cn = 0;
			                  	if ($loop->have_posts()) :  while ($loop->have_posts()) : $loop->the_post();$cn++;
			                ?>							
		        	
		            		<div class="blog-detail wow fadeInUp" data-wow-duration=".5s">
		            			<div class="col-sm-12 col-md-6 img-list">
				              		<div class="image">
										<?php if (has_post_thumbnail()) : ?>
								  		<?php the_post_thumbnail('full', 'img-responsive'); ?>
										<?php else : ?>
											<div class="no-img"><i class="fa fa-camera-retro fa-5x"></i></div>
										<?php endif; ?>
									</div>

									<div class="fpage1 post-dates">
							      		<div class="month-day"><?php echo get_the_date('d M');?></div>
							      		<div class="year"><?php echo get_the_date('Y');?></div>
							  		</div>
								</div><!--col-sm-4 img-list end--> 
						      
								<div class="col-sm-12 col-md-6 list-content">    
									<h4><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h4>
									<p><?php esc_attr( 'Published On :', 'whiteboard64-pro' ); ?> <?php echo whiteboard64_pro_time_ago(); ?></p>
									<?php echo whiteboard64_pro_content(80); ?>
									<a class="btn btn-default" href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php printf( 'Full Details', 'whiteboard64-pro' ); ?></a>
									<div class="meta-socials"><?php echo whiteboard64_pro_social_share(); ?></div>
								</div><!-- list content end--> 
		            		</div> <!--blog-detail end--> 
				          	<?php                 
			                  	endwhile;
			                    wp_reset_postdata();  
			                  	endif;                             
			                  	}
			                ?>

			                <img class="img-responsive center-block blog-bg" src="<?php echo get_template_directory_uri(); ?>/img/shadow3.png" alt="" />
			            </div>
		          	</div>  <!--col-sm-4 end--> 


	                <div class="col-sm-12 list_posts">
	                	<div class="row">
		                	<?php
								$cid = get_theme_mod('news1_category_display');
								$nid = get_theme_mod('category1_no');
								$category_link = get_category_link($cid);
								$whiteboard64_cat = get_category($cid);
								if ($whiteboard64_cat) {
				        	?>
				        	<?php
					            $args = array(
					              'posts_per_page' => $nid,
					              'paged' => 1,
					              'offset' => 1,
					              'cat' => $cid
					            );
					            $loop = new WP_Query($args);					            
					            $cn = 0;
					            if ($loop->have_posts()) :  while ($loop->have_posts()) : $loop->the_post();$cn++;
					        ?>
					        <div class="col-xs-12 col-sm-12 col-md-4">
				            	<div class="blog-details wow fadeInUp" data-wow-duration=".5s">
				              		<figure>
				                		<?php if (has_post_thumbnail()) : ?>
				                			<?php the_post_thumbnail('large'); ?>
				                		<?php else : ?>
				                  			<div class="no-img"><i class="fa fa-camera-retro fa-5x"></i></div>
				                		<?php endif; ?> 
				                		<div class="detail-date">
								        	<div class="month-day"><?php echo get_the_date('d M');?></div>
								        	<div class="year"><?php echo get_the_date('Y');?></div>
								    	</div>	                       
				                  
				                		<figcaption>
				                  			<div>    
							                    <a class="popular" href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a>
							                    <?php echo whiteboard64_pro_content(18); ?>
							                    <a class="btn btn-primary" href="<?php the_permalink(); ?>" rel="bookmark"><?php printf( 'Full Details', 'whiteboard64-pro' ); ?></a>
				                  			</div>
				                		</figcaption>
				              		</figure> <!--figure end--> 
				            	</div> <!--blog-details end--> 
				          	</div>  <!--col-sm-4 end-->						        
				          	<?php                 
				      			endwhile;
				      				wp_reset_postdata();  
				      			endif;                             
				    			}
			    			?> 

			    			<!-- Add Banner -->
							<?php if ( is_active_sidebar( 'homepage-ad1-block' ) ) : ?>
								<div class="col-xs-12 col-sm-12">
									<?php dynamic_sidebar( 'homepage-ad1-block' ); ?>
								</div>
							<?php endif; ?>
			    		</div>
		    		</div>
		    		<img class="img-responsive center-block blog-bg" src="<?php echo get_template_directory_uri(); ?>/img/shadow3.png" alt="" />
		    	</div> <!-- news-tab ends -->




		    	<div class="news-tab">
					<div class="col-sm-12 col-md-12 special">
		        		<div class="row">
							<?php
				                $cid = get_theme_mod('news2_category_display');
				                $whiteboard64_cat = get_category($cid);
				                if ($whiteboard64_cat) {
			                ?>

			                <div class="col-sm-12 category-title">
			                	<h3><?php echo ''.esc_attr( get_cat_name( get_theme_mod('news2_category_display') ) ).''?></h3>
		        				<div class="view-category text-right">
		        					<a href="<?php echo get_category_link($cid); ?>">View All</a>
		        				</div>
		        			</div>

		        			<div class="col-sm-12 col-md-6">
				                <?php
				                  	$args = array(
				                    'posts_per_page' => 1,
				                    'paged' => 1,
				                    'cat' => $cid
				                  	);
				                  	$loop = new WP_Query($args);
				                  
				                  	$cn = 0;
				                  	if ($loop->have_posts()) :  while ($loop->have_posts()) : $loop->the_post();$cn++;
				                ?>							
		        	
			            		<div class="blog-detail wow fadeInUp" data-wow-duration=".5s">
			            			<div class="img-list">
					              		<div class="image">
											<?php if (has_post_thumbnail()) : ?>
									  		<?php the_post_thumbnail('full', 'img-responsive'); ?>
											<?php else : ?>
												<div class="no-img"><i class="fa fa-camera-retro fa-5x"></i></div>
											<?php endif; ?>
										</div>

										<div class="fpage1 post-dates">
								      		<div class="month-day"><?php echo get_the_date('d M');?></div>
								      		<div class="year"><?php echo get_the_date('Y');?></div>
								  		</div>
									</div><!--col-sm-4 img-list end--> 

							      	<div class="clearfix"></div>

									<div class="list-content">    
										<h4><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h4>
										<p><?php esc_attr( 'Published On :', 'whiteboard64-pro' ); ?> <?php echo whiteboard64_pro_time_ago(); ?></p>
										<?php echo whiteboard64_pro_content(80); ?>
										<a class="btn btn-default" href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php printf( 'Full Details', 'whiteboard64-pro' ); ?></a>
										<div class="meta-socials"><?php echo whiteboard64_pro_social_share(); ?></div>
									</div><!-- list content end--> 
			            		</div> <!--blog-detail end--> 

					          	<?php                 
				                  	endwhile;
				                    wp_reset_postdata();  
				                  	endif;                             
				                  	}
				                ?>
				            </div>

				            <div class="col-sm-12 col-md-6 list-posts">
			                	<div class="row">
				                	<?php
										$cid = get_theme_mod('news2_category_display');
										$nid = get_theme_mod('category2_no');
										$category_link = get_category_link($cid);
										$whiteboard64_cat = get_category($cid);
										if ($whiteboard64_cat) {
						        	?>
						        	<?php
							            $args = array(
							              'posts_per_page' => $nid,
							              'paged' => 1,
							              'offset' => 1,
							              'cat' => $cid
							            );
							            $loop = new WP_Query($args);					            
							            $cn = 0;
							            if ($loop->have_posts()) :  while ($loop->have_posts()) : $loop->the_post();$cn++;
							        ?>
							        <div class="col-sm-12 col-md-6">
						            	<div class="blog-details wow fadeInUp" data-wow-duration=".5s">
						              		<figure>
						                		<?php if (has_post_thumbnail()) : ?>
						                			<?php the_post_thumbnail('large'); ?>
						                		<?php else : ?>
						                  			<div class="no-img"><i class="fa fa-camera-retro fa-5x"></i></div>
						                		<?php endif; ?> 
						                		<div class="detail-date">
										        	<div class="month-day"><?php echo get_the_date('d M');?></div>
										        	<div class="year"><?php echo get_the_date('Y');?></div>
										    	</div>	                       
						                  
						                		<figcaption>
						                  			<div>    
									                    <a class="popular" href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a>
									                    <?php echo whiteboard64_pro_content(18); ?>
									                    <a class="btn btn-primary" href="<?php the_permalink(); ?>" rel="bookmark"><?php printf( 'Full Details', 'whiteboard64-pro' ); ?></a>
						                  			</div>
						                		</figcaption>
						              		</figure> <!--figure end--> 
						            	</div> <!--blog-details end--> 
						          	</div>  <!--col-sm-4 end-->						        
						          	<?php                 
						      			endwhile;
						      				wp_reset_postdata();  
						      			endif;                             
						    			}
					    			?>
					    		</div>
					    	</div>

					    	<!-- Add Banner -->
							<?php if ( is_active_sidebar( 'homepage-ad2-block' ) ) : ?>
								<div class="col-xs-12 col-sm-12">
									<?php dynamic_sidebar( 'homepage-ad2-block' ); ?>
								</div>
							<?php endif; ?>

			                <img class="img-responsive center-block blog-bg" src="<?php echo get_template_directory_uri(); ?>/img/shadow3.png" alt="" />
			            </div>
		          	</div>  <!--col-sm-4 end--> 
		    	</div> <!-- news-tab ends -->

					

				
				<div class="news-tab">
					<div class="col-xs-12 col-sm-12">
		        		<div class="row">
		        			
		        			<?php
				                $cid = get_theme_mod('news3_category_display');
				                $whiteboard64_cat = get_category($cid);
				                if ($whiteboard64_cat) {
			                ?>
			                <div class="col-sm-12 category-title">
			                	<h3><?php echo ''.esc_attr( get_cat_name( get_theme_mod('news3_category_display') ) ).''?></h3>
		        				<div class="view-category text-right">
		        					<a href="<?php echo get_category_link($cid); ?>">View All</a>
		        				</div>
		        			</div>

			                <?php
			                  	$args = array(
			                    'posts_per_page' => 1,
			                    'paged' => 1,
			                    'cat' => $cid
			                  	);
			                  	$loop = new WP_Query($args);
			                  
			                  	$cn = 0;
			                  	if ($loop->have_posts()) :  while ($loop->have_posts()) : $loop->the_post();$cn++;
			                ?>							
		        	
		            		<div class="blog-detail wow fadeInUp" data-wow-duration=".5s">
		            			<div class="col-sm-12 col-md-6 img-list">
				              		<div class="image">
										<?php if (has_post_thumbnail()) : ?>
								  		<?php the_post_thumbnail('full', 'img-responsive'); ?>
										<?php else : ?>
											<div class="no-img"><i class="fa fa-camera-retro fa-5x"></i></div>
										<?php endif; ?>
									</div>

									<div class="post-date">
							      		<div class="month-day"><?php echo get_the_date('d M');?></div>
							      		<div class="year"><?php echo get_the_date('Y');?></div>
							  		</div>
								</div><!--col-sm-4 img-list end--> 
						      
								<div class="col-sm-12 col-md-6 list-content">    
									<h4><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h4>
									<p><?php esc_attr( 'Published On :', 'whiteboard64-pro' ); ?> <?php echo whiteboard64_pro_time_ago(); ?></p>
									<?php echo whiteboard64_pro_content(80); ?>
									<a class="btn btn-default" href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php printf( 'Full Details', 'whiteboard64-pro' ); ?></a>
									<div class="meta-socials"><?php echo whiteboard64_pro_social_share(); ?></div>
								</div><!-- list content end--> 
		            		</div> <!--blog-detail end--> 
				          	<?php                 
			                  	endwhile;
			                    wp_reset_postdata();  
			                  	endif;                             
			                  	}
			                ?>

			                <img class="img-responsive center-block blog-bg" src="<?php echo get_template_directory_uri(); ?>/img/shadow3.png" alt="" />
			            </div>
		          	</div>  <!--col-sm-4 end--> 


	                <div class="col-sm-12 list_posts">
	                	<div class="row">
		                	<?php
								$cid = get_theme_mod('news3_category_display');
								$nid = get_theme_mod('category3_no');
								$category_link = get_category_link($cid);
								$whiteboard64_cat = get_category($cid);
								if ($whiteboard64_cat) {
				        	?>
				        	<?php
					            $args = array(
					              'posts_per_page' => $nid,
					              'paged' => 1,
					              'offset' => 1,
					              'cat' => $cid
					            );
					            $loop = new WP_Query($args);					            
					            $cn = 0;
					            if ($loop->have_posts()) :  while ($loop->have_posts()) : $loop->the_post();$cn++;
					        ?>
					        <div class="col-xs-12 col-sm-12 col-md-4">
				            	<div class="blog-details wow fadeInUp" data-wow-duration=".5s">
				              		<figure>
				                		<?php if (has_post_thumbnail()) : ?>
				                			<?php the_post_thumbnail('large'); ?>
				                		<?php else : ?>
				                  			<div class="no-img"><i class="fa fa-camera-retro fa-5x"></i></div>
				                		<?php endif; ?> 
				                		<div class="detail-date">
								        	<div class="month-day"><?php echo get_the_date('d M');?></div>
								        	<div class="year"><?php echo get_the_date('Y');?></div>
								    	</div>	                       
				                  
				                		<figcaption>
				                  			<div>    
							                    <a class="popular" href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a>
							                    <?php echo whiteboard64_pro_content(18); ?>
							                    <a class="btn btn-primary" href="<?php the_permalink(); ?>" rel="bookmark"><?php printf( 'Full Details', 'whiteboard64-pro' ); ?></a>
				                  			</div>
				                		</figcaption>
				              		</figure> <!--figure end--> 
				            	</div> <!--blog-details end--> 
				          	</div>  <!--col-sm-4 end-->						        
				          	<?php                 
				      			endwhile;
				      				wp_reset_postdata();  
				      			endif;                             
				    			}
			    			?> 

			    			<!-- Add Banner -->
							<?php if ( is_active_sidebar( 'homepage-ad3-block' ) ) : ?>
								<div class="col-xs-12 col-sm-12">
									<?php dynamic_sidebar( 'homepage-ad3-block' ); ?>
								</div>
							<?php endif; ?>
			    		</div>
		    		</div>
		    	</div> <!-- news-tab ends -->




		    	<div class="news-tab">
					<div class="col-sm-12 col-md-12 special">
		        		<div class="row">
							<?php
				                $cid = get_theme_mod('news4_category_display');
				                $whiteboard64_cat = get_category($cid);
				                if ($whiteboard64_cat) {
			                ?>

			                <div class="col-sm-12 category-title">
			                	<h3><?php echo ''.esc_attr( get_cat_name( get_theme_mod('news4_category_display') ) ).''?></h3>
		        				<div class="view-category text-right">
		        					<a href="<?php echo get_category_link($cid); ?>">View All</a>
		        				</div>
		        			</div>

		        			<div class="col-sm-12 col-md-6">
				                <?php
				                  	$args = array(
				                    'posts_per_page' => 1,
				                    'paged' => 1,
				                    'cat' => $cid
				                  	);
				                  	$loop = new WP_Query($args);
				                  
				                  	$cn = 0;
				                  	if ($loop->have_posts()) :  while ($loop->have_posts()) : $loop->the_post();$cn++;
				                ?>							
		        	
			            		<div class="blog-detail wow fadeInUp" data-wow-duration=".5s">
			            			<div class="img-list">
					              		<div class="image">
											<?php if (has_post_thumbnail()) : ?>
									  		<?php the_post_thumbnail('full', 'img-responsive'); ?>
											<?php else : ?>
												<div class="no-img"><i class="fa fa-camera-retro fa-5x"></i></div>
											<?php endif; ?>
										</div>

										<div class="fpage1 post-dates">
								      		<div class="month-day"><?php echo get_the_date('d M');?></div>
								      		<div class="year"><?php echo get_the_date('Y');?></div>
								  		</div>
									</div><!--col-sm-4 img-list end--> 

							      	<div class="clearfix"></div>

									<div class="list-content">    
										<h4><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h4>
										<p><?php esc_attr( 'Published On :', 'whiteboard64-pro' ); ?> <?php echo whiteboard64_pro_time_ago(); ?></p>
										<?php echo whiteboard64_pro_content(80); ?>
										<a class="btn btn-default" href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php printf( 'Full Details', 'whiteboard64-pro' ); ?></a>
										<div class="meta-socials"><?php echo whiteboard64_pro_social_share(); ?></div>
									</div><!-- list content end--> 
			            		</div> <!--blog-detail end--> 

					          	<?php                 
				                  	endwhile;
				                    wp_reset_postdata();  
				                  	endif;                             
				                  	}
				                ?>
				            </div>

				            <div class="col-sm-12 col-md-6 list-posts">
			                	<div class="row">
				                	<?php
										$cid = get_theme_mod('news4_category_display');
										$nid = get_theme_mod('category4_no');
										$category_link = get_category_link($cid);
										$whiteboard64_cat = get_category($cid);
										if ($whiteboard64_cat) {
						        	?>
						        	<?php
							            $args = array(
							              'posts_per_page' => $nid,
							              'paged' => 1,
							              'offset' => 1,
							              'cat' => $cid
							            );
							            $loop = new WP_Query($args);					            
							            $cn = 0;
							            if ($loop->have_posts()) :  while ($loop->have_posts()) : $loop->the_post();$cn++;
							        ?>
							        <div class="col-sm-12 col-md-6">
						            	<div class="blog-details wow fadeInUp" data-wow-duration=".5s">
						              		<figure>
						                		<?php if (has_post_thumbnail()) : ?>
						                			<?php the_post_thumbnail('large'); ?>
						                		<?php else : ?>
						                  			<div class="no-img"><i class="fa fa-camera-retro fa-5x"></i></div>
						                		<?php endif; ?> 
						                		<div class="detail-date">
										        	<div class="month-day"><?php echo get_the_date('d M');?></div>
										        	<div class="year"><?php echo get_the_date('Y');?></div>
										    	</div>	                       
						                  
						                		<figcaption>
						                  			<div>    
									                    <a class="popular" href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a>
									                    <?php echo whiteboard64_pro_content(18); ?>
									                    <a class="btn btn-primary" href="<?php the_permalink(); ?>" rel="bookmark"><?php printf( 'Full Details', 'whiteboard64-pro' ); ?></a>
						                  			</div>
						                		</figcaption>
						              		</figure> <!--figure end--> 
						            	</div> <!--blog-details end--> 
						          	</div>  <!--col-sm-4 end-->						        
						          	<?php                 
						      			endwhile;
						      				wp_reset_postdata();  
						      			endif;                             
						    			}
					    			?>
					    		</div>
					    	</div>

					    	<!-- Add Banner -->
							<?php if ( is_active_sidebar( 'homepage-ad4-block' ) ) : ?>
								<div class="col-xs-12 col-sm-12">
									<?php dynamic_sidebar( 'homepage-ad4-block' ); ?>
								</div>
							<?php endif; ?>

			                <img class="img-responsive center-block blog-bg" src="<?php echo get_template_directory_uri(); ?>/img/shadow3.png" alt="" />
			            </div>
		          	</div>  <!--col-sm-4 end--> 
		    	</div> <!-- news-tab ends -->		    	




		    	<div class="news-tab">
					<div class="col-xs-12 col-sm-12">
		        		<div class="row">
		        			
		        			<?php
				                $cid = get_theme_mod('news5_category_display');
				                $whiteboard64_cat = get_category($cid);
				                if ($whiteboard64_cat) {
			                ?>
			                <div class="col-sm-12 category-title">
			                	<h3><?php echo ''.esc_attr( get_cat_name( get_theme_mod('news5_category_display') ) ).''?></h3>
		        				<div class="view-category text-right">
		        					<a href="<?php echo get_category_link($cid); ?>">View All</a>
		        				</div>
		        			</div>

			                <?php
			                  	$args = array(
			                    'posts_per_page' => 1,
			                    'paged' => 1,
			                    'cat' => $cid
			                  	);
			                  	$loop = new WP_Query($args);
			                  
			                  	$cn = 0;
			                  	if ($loop->have_posts()) :  while ($loop->have_posts()) : $loop->the_post();$cn++;
			                ?>							
		        	
		            		<div class="blog-detail wow fadeInUp" data-wow-duration=".5s">
		            			<div class="col-sm-12 col-md-6 img-list">
				              		<div class="image">
										<?php if (has_post_thumbnail()) : ?>
								  		<?php the_post_thumbnail('full', 'img-responsive'); ?>
										<?php else : ?>
											<div class="no-img"><i class="fa fa-camera-retro fa-5x"></i></div>
										<?php endif; ?>
									</div>

									<div class="post-date">
							      		<div class="month-day"><?php echo get_the_date('d M');?></div>
							      		<div class="year"><?php echo get_the_date('Y');?></div>
							  		</div>
								</div><!--col-sm-4 img-list end--> 
						      
								<div class="col-sm-12 col-md-6 list-content">    
									<h4><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h4>
									<p><?php esc_attr( 'Published On :', 'whiteboard64-pro' ); ?> <?php echo whiteboard64_pro_time_ago(); ?></p>
									<?php echo whiteboard64_pro_content(80); ?>
									<a class="btn btn-default" href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php printf( 'Full Details', 'whiteboard64-pro' ); ?></a>
									<div class="meta-socials"><?php echo whiteboard64_pro_social_share(); ?></div>
								</div><!-- list content end--> 
		            		</div> <!--blog-detail end--> 
				          	<?php                 
			                  	endwhile;
			                    wp_reset_postdata();  
			                  	endif;                             
			                  	}
			                ?>

			                <img class="img-responsive center-block blog-bg" src="<?php echo get_template_directory_uri(); ?>/img/shadow3.png" alt="" />
			            </div>
		          	</div>  <!--col-sm-4 end--> 


	                <div class="col-sm-12 list_posts">
	                	<div class="row">
		                	<?php
								$cid = get_theme_mod('news5_category_display');
								$nid = get_theme_mod('category5_no');
								$category_link = get_category_link($cid);
								$whiteboard64_cat = get_category($cid);
								if ($whiteboard64_cat) {
				        	?>
				        	<?php
					            $args = array(
					              'posts_per_page' => $nid,
					              'paged' => 1,
					              'offset' => 1,
					              'cat' => $cid
					            );
					            $loop = new WP_Query($args);					            
					            $cn = 0;
					            if ($loop->have_posts()) :  while ($loop->have_posts()) : $loop->the_post();$cn++;
					        ?>
					        <div class="col-xs-12 col-sm-12 col-md-4">
				            	<div class="blog-details wow fadeInUp" data-wow-duration=".5s">
				              		<figure>
				                		<?php if (has_post_thumbnail()) : ?>
				                			<?php the_post_thumbnail('large'); ?>
				                		<?php else : ?>
				                  			<div class="no-img"><i class="fa fa-camera-retro fa-5x"></i></div>
				                		<?php endif; ?> 
				                		<div class="detail-date">
								        	<div class="month-day"><?php echo get_the_date('d M');?></div>
								        	<div class="year"><?php echo get_the_date('Y');?></div>
								    	</div>	                       
				                  
				                		<figcaption>
				                  			<div>    
							                    <a class="popular" href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a>
							                    <?php echo whiteboard64_pro_content(18); ?>
							                    <a class="btn btn-primary" href="<?php the_permalink(); ?>" rel="bookmark"><?php printf( 'Full Details', 'whiteboard64-pro' ); ?></a>
				                  			</div>
				                		</figcaption>
				              		</figure> <!--figure end--> 
				            	</div> <!--blog-details end--> 
				          	</div>  <!--col-sm-4 end-->						        
				          	<?php                 
				      			endwhile;
				      				wp_reset_postdata();  
				      			endif;                             
				    			}
			    			?> 

			    			<!-- Add Banner -->
							<?php if ( is_active_sidebar( 'homepage-ad5-block' ) ) : ?>
								<div class="col-xs-12 col-sm-12">
									<?php dynamic_sidebar( 'homepage-ad5-block' ); ?>
								</div>
							<?php endif; ?>
			    		</div>
		    		</div>
		    	</div> <!-- news-tab ends -->




		    	<div class="news-tab">
					<div class="col-sm-12 col-md-12 special">
		        		<div class="row">
							<?php
				                $cid = get_theme_mod('news6_category_display');
				                $whiteboard64_cat = get_category($cid);
				                if ($whiteboard64_cat) {
			                ?>

			                <div class="col-sm-12 category-title">
			                	<h3><?php echo ''.esc_attr( get_cat_name( get_theme_mod('news6_category_display') ) ).''?></h3>
		        				<div class="view-category text-right">
		        					<a href="<?php echo get_category_link($cid); ?>">View All</a>
		        				</div>
		        			</div>

		        			<div class="col-sm-12 col-md-6">
				                <?php
				                  	$args = array(
				                    'posts_per_page' => 1,
				                    'paged' => 1,
				                    'cat' => $cid
				                  	);
				                  	$loop = new WP_Query($args);
				                  
				                  	$cn = 0;
				                  	if ($loop->have_posts()) :  while ($loop->have_posts()) : $loop->the_post();$cn++;
				                ?>							
		        	
			            		<div class="blog-detail wow fadeInUp" data-wow-duration=".5s">
			            			<div class="img-list">
					              		<div class="image">
											<?php if (has_post_thumbnail()) : ?>
									  		<?php the_post_thumbnail('full', 'img-responsive'); ?>
											<?php else : ?>
												<div class="no-img"><i class="fa fa-camera-retro fa-5x"></i></div>
											<?php endif; ?>
										</div>

										<div class="fpage1 post-dates">
								      		<div class="month-day"><?php echo get_the_date('d M');?></div>
								      		<div class="year"><?php echo get_the_date('Y');?></div>
								  		</div>
									</div><!--col-sm-4 img-list end--> 

							      	<div class="clearfix"></div>

									<div class="list-content">    
										<h4><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h4>
										<p><?php esc_attr( 'Published On :', 'whiteboard64-pro' ); ?> <?php echo whiteboard64_pro_time_ago(); ?></p>
										<?php echo whiteboard64_pro_content(80); ?>
										<a class="btn btn-default" href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php printf( 'Full Details', 'whiteboard64-pro' ); ?></a>
										<div class="meta-socials"><?php echo whiteboard64_pro_social_share(); ?></div>
									</div><!-- list content end--> 
			            		</div> <!--blog-detail end--> 

					          	<?php                 
				                  	endwhile;
				                    wp_reset_postdata();  
				                  	endif;                             
				                  	}
				                ?>
				            </div>

				            <div class="col-sm-12 col-md-6 list-posts">
			                	<div class="row">
				                	<?php
										$cid = get_theme_mod('news6_category_display');
										$nid = get_theme_mod('category6_no');
										$category_link = get_category_link($cid);
										$whiteboard64_cat = get_category($cid);
										if ($whiteboard64_cat) {
						        	?>
						        	<?php
							            $args = array(
							              'posts_per_page' => $nid,
							              'paged' => 1,
							              'offset' => 1,
							              'cat' => $cid
							            );
							            $loop = new WP_Query($args);					            
							            $cn = 0;
							            if ($loop->have_posts()) :  while ($loop->have_posts()) : $loop->the_post();$cn++;
							        ?>
							        <div class="col-sm-12 col-md-6">
						            	<div class="blog-details wow fadeInUp" data-wow-duration=".5s">
						              		<figure>
						                		<?php if (has_post_thumbnail()) : ?>
						                			<?php the_post_thumbnail('large'); ?>
						                		<?php else : ?>
						                  			<div class="no-img"><i class="fa fa-camera-retro fa-5x"></i></div>
						                		<?php endif; ?> 
						                		<div class="detail-date">
										        	<div class="month-day"><?php echo get_the_date('d M');?></div>
										        	<div class="year"><?php echo get_the_date('Y');?></div>
										    	</div>	                       
						                  
						                		<figcaption>
						                  			<div>    
									                    <a class="popular" href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a>
									                    <?php echo whiteboard64_pro_content(18); ?>
									                    <a class="btn btn-primary" href="<?php the_permalink(); ?>" rel="bookmark"><?php printf( 'Full Details', 'whiteboard64-pro' ); ?></a>
						                  			</div>
						                		</figcaption>
						              		</figure> <!--figure end--> 
						            	</div> <!--blog-details end--> 
						          	</div>  <!--col-sm-4 end-->						        
						          	<?php                 
						      			endwhile;
						      				wp_reset_postdata();  
						      			endif;                             
						    			}
					    			?>
					    		</div>
					    	</div>

					    	<!-- Add Banner -->
							<?php if ( is_active_sidebar( 'homepage-ad6-block' ) ) : ?>
								<div class="col-xs-12 col-sm-12">
									<?php dynamic_sidebar( 'homepage-ad6-block' ); ?>
								</div>
							<?php endif; ?>

			                <img class="img-responsive center-block blog-bg" src="<?php echo get_template_directory_uri(); ?>/img/shadow3.png" alt="" />
			            </div>
		          	</div>  <!--col-sm-4 end--> 
		    	</div> <!-- news-tab ends -->





				<?php 
    			$show_carousel = get_theme_mod('news_carousel_display' );
    			if ( $show_carousel) {?>
				<div class="news-updates">
					<div class="caps">
						<span><?php echo esc_attr(get_theme_mod( 'popular_title', __( 'Most Popular News', 'whiteboard64-pro' ) ) ); ?></span>
					</div> 

					<div id="slider1" class="wow fadeInUp">
		                <a class="buttons prev" href="#"><i class="fa fa-angle-left"></i></a>
		                <div class="viewport">
		                    <ul class="overview">
		                    	<?php
									$cid = get_theme_mod('news7_category_display');
									$nid = get_theme_mod('category7_no');
									$category_link = get_category_link($cid);
									$whiteboard64_cat = get_category($cid);
									if ($whiteboard64_cat) {
						    	?>
						    	<?php
						            $args = array(
						              'posts_per_page' => $nid,
						              'paged' => 1,
						              'cat' => $cid
						            );
						            $loop = new WP_Query($args);					            
						            $cn = 0;
						            if ($loop->have_posts()) :  while ($loop->have_posts()) : $loop->the_post();$cn++;
						        ?>
					        	<li class="col-md-3 col-sm-6 item single">
					        		<div class="blog-details">
					              		<figure>
					                		<?php if (has_post_thumbnail()) : ?>
					                  			<?php the_post_thumbnail('full'); ?>
					                		<?php else : ?>
					                  			<div class="no-img"><i class="fa fa-camera-retro fa-5x"></i></div>
					                		<?php endif; ?> 
					                		<div class="detail-date">
									        	<div class="month-day"><?php echo get_the_date('d M');?></div>
									        	<div class="year"><?php echo get_the_date('Y');?></div>
									    	</div>	                       
					                  
					                		<figcaption>
					                  			<div>    
								                    <a class="popular" href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a>
					                  			</div>
					                		</figcaption>
					              		</figure> <!--figure end--> 
					            	</div> <!--blog-details end-->
				            	</li><!-- end box -->
				            	
							    <?php                 
				                  	endwhile;
				                    wp_reset_postdata();  
				                  	endif;                             
				                  	}
				                ?>
					    	</ul><!-- .overview -->
					    </div> <!-- .viewport -->
					    <a class="buttons next" href="#"><i class="fa fa-angle-right"></i></a>         
					</div><!-- #slider1 -->
				</div><!-- .news-updates -->
				<?php }?>

			</div><!-- .container -->
		</main><!-- #main -->
	</div><!-- #primary -->

<?php
get_footer();