<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Whiteboard64 Pro
 */

?>

		<footer id="colophon" class="site-footer" role="contentinfo">
			<div class="container">
				<?php if ( is_active_sidebar( 'footer-block' ) ) : ?>
					<div class="footer wow fadeInUp" data-wow-duration="2s">
						<?php dynamic_sidebar( 'footer-block' ); ?>
					</div><!-- .footer -->
				<?php endif; ?>

				<?php 
    			$show_footer_socials = get_theme_mod('whiteboard64-pro_socials_display' );
    			if ( $show_footer_socials) {?>
				<div class="col-sm-12 col-md-12 wow fadeInUp" data-wow-duration="2s">
					<ul class="footer-socials text-center"> 
						<?php 	               	
		               	$facebook =  esc_url(get_theme_mod('facebook_link'));
		                $twitter = esc_url(get_theme_mod('twitter_link'));
		                $googleplus = esc_url(get_theme_mod('googleplus_link'));
		                $linkedin = esc_url(get_theme_mod('linkedin_link'));
		                $youtube = esc_url(get_theme_mod('youtube_link')); 

		                $instagram = esc_url(get_theme_mod('instagram_link'));
		                $pinterest = esc_url(get_theme_mod('pinterest_link'));
		                $stumbleupon = esc_url(get_theme_mod('stumbleupon_link'));
		                $tumblr = esc_url(get_theme_mod('tumblr_link'));
		                $medium = esc_url(get_theme_mod('medium_link'));
		                
		                if($facebook){?>
		                <li><a target="_blank" href="<?php echo esc_url($facebook); ?>"><i class="fa fa-facebook"></i></a></li>
		                <?php }
		                if($twitter){?>
		                <li><a target="_blank" href="<?php echo esc_url($twitter); ?>"><i class="fa fa-twitter"></i></a></li>
		                <?php }
		                if($googleplus){?>
		                <li><a target="_blank" href="<?php echo esc_url($googleplus); ?>"><i class="fa fa-google-plus"></i></a></li>
		                <?php }
		                if($linkedin){?>
		                <li><a target="_blank" href="<?php echo esc_url($linkedin); ?>"><i class="fa fa-linkedin"></i></a></li>
		                <?php }
		                if($youtube){?>
		                <li><a target="_blank" href="<?php echo esc_url($youtube); ?>"><i class="fa fa-youtube"></i></a></li>
		                <?php }

		                if($instagram){?>
		                <li><a target="_blank" href="<?php echo esc_url($instagram); ?>"><i class="fa fa-instagram"></i></a></li>
		                <?php }
		                if($pinterest){?>
		                <li><a target="_blank" href="<?php echo esc_url($pinterest); ?>"><i class="fa fa-pinterest"></i></a></li>
		                <?php }
		                if($stumbleupon){?>
		                <li><a target="_blank" href="<?php echo esc_url($stumbleupon); ?>"><i class="fa fa-stumbleupon"></i></a></li>
		                <?php }
		                if($tumblr){?>
		                <li><a target="_blank" href="<?php echo esc_url($tumblr); ?>"><i class="fa fa-tumblr"></i></a></li>
		                <?php }
		                if($medium){?>
		                <li><a target="_blank" href="<?php echo esc_url($medium); ?>"><i class="fa fa-medium"></i></a></li>
		                <?php }
		            	?> 
					</ul><!-- .socials -->
				</div><!-- .socialicons -->
				<?php }?>

			</div><!-- .container -->
		</footer><!-- #colophon -->


		<?php 
		$show_sidebar_socials = get_theme_mod('whiteboard64-pro_sidebar_socials_display' );
		if ( $show_sidebar_socials) {?>
		<div class="social-tab">
			<ul> 
				<?php 	               	
               	$facebook =  esc_url(get_theme_mod('facebook_link'));
                $twitter = esc_url(get_theme_mod('twitter_link'));
                $googleplus = esc_url(get_theme_mod('googleplus_link'));
                $linkedin = esc_url(get_theme_mod('linkedin_link'));
                $youtube = esc_url(get_theme_mod('youtube_link')); 
                
                if($facebook){?>
                <li><a target="_blank" href="<?php echo esc_url($facebook); ?>"><?php esc_html_e( 'FaceBook', 'whiteboard64-pro' ); ?> <i class="fa fa-facebook"></i></a></li>
                <?php }
                if($twitter){?>
                <li><a target="_blank" href="<?php echo esc_url($twitter); ?>"><?php esc_html_e( 'Twitter', 'whiteboard64-pro' ); ?> <i class="fa fa-twitter"></i></a></li>
                <?php }
                if($googleplus){?>
                <li><a target="_blank" href="<?php echo esc_url($googleplus); ?>"><?php esc_html_e( 'Google +', 'whiteboard64-pro' ); ?> <i class="fa fa-google-plus"></i></a></li>
                <?php }
                if($linkedin){?>
                <li><a target="_blank" href="<?php echo esc_url($linkedin); ?>"><?php esc_html_e( 'LinkedIn', 'whiteboard64-pro' ); ?> <i class="fa fa-linkedin"></i></a></li>
                <?php }
                if($youtube){?>
                <li><a target="_blank" href="<?php echo esc_url($youtube); ?>"><?php esc_html_e( 'YouTuble', 'whiteboard64-pro' ); ?> <i class="fa fa-youtube"></i></a></li>
                <?php }
            	?> 
			</ul><!-- .socials -->
		</div>
		<?php }?>

		<div class="site-info  wow fadeInUp" data-wow-duration="2s">
			<?php printf( esc_html__( 'Copyright &copy;', 'whiteboard64-pro' ));  echo date("Y"); ?>
			<span class="sep"> | </span>

			<a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>		

			<?php 
			$show_footer_credits = get_theme_mod('whiteboard64-pro_footer_credits_display' );
			if ( $show_footer_credits) {?>

			<span class="sep"> | </span>
			<a href="<?php echo esc_url( __( 'https://wordpress.org/', 'whiteboard64-pro' ) ); ?>"><?php printf( esc_html__( 'Proudly powered by %s', 'whiteboard64-pro' ), 'WordPress' ); ?></a>
			<span class="sep"> | </span>
			
			<?php printf( esc_html__( 'Theme: %1$s by %2$s.', 'whiteboard64-pro' ), 'whiteboard64-pro', '<a href="'.esc_url( __( 'http://sumanshresthaa.com.np', 'whiteboard64-pro' ) ).'" rel="designer">Suman Shrestha</a>' ); ?>	
			<?php }?>


			<?php 
			$show_footer_disclaimer = get_theme_mod('whiteboard64-pro_footer_disclaimer_display' );
			if ( $show_footer_disclaimer) {?>
				<p><?php echo esc_html(get_theme_mod( 'disclaimer_title', __( '', 'whiteboard64-pro' ) ) ); ?></p>
			<?php }?>

		</div><!-- .site-info -->

		<div class="scroll-top-wrapper">
			<span class="scroll-top-inner"><i class="fa fa-angle-double-up"></i></span>
		</div>
		
	<?php wp_footer(); ?>
	</body>
</html>