<?php
/**
 * The template for displaying archive pages
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Whiteboard64 Pro
 */

get_header(); ?>
	
	<div class="innerpage">
		<img src="<?php header_image(); ?>" class="header-image feaImg img-responsive center-block" />
	</div>
	
	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">
			<div class="container">

				<?php
				  	$class = 'col-md-12';
				  	$sidebar =  get_theme_mod('category_sidebar_position');
				   		if($sidebar != 'none'){
				      	$class = 'col-md-9';
				  	}
				?> 
				<?php
				  if ($sidebar == 'left'){			     
				      	get_sidebar('left');
				    }
				?>
				<div class="<?php echo $class;?> detail-content">
					<!-- Add Banner -->
					<?php if ( is_active_sidebar( 'innerpage-ad-block' ) ) : ?>
						<?php dynamic_sidebar( 'innerpage-ad-block' ); ?>
					<?php endif; ?>
					
					<?php
					if ( have_posts() ) : ?>

						<header class="page-header">
							<?php
								the_archive_title( '<h1 class="page-title">', '</h1>' );
								the_archive_description( '<div class="archive-description">', '</div>' );
							?>
						</header><!-- .page-header -->

						<?php 
					    $show_categoryslider_in_archive = get_theme_mod('whiteboard64-pro_categorysliderposts_display' );
					    if ( $show_categoryslider_in_archive) {?>

						<div class="categoryposts-slider">
							<div id="carousel-whiteboard64-pro" class="carousel slide" data-ride="carousel">
								<div class="carousel-inner" role="listbox">								

						        	<?php
						        		$category = get_queried_object();
									?>
									<?php 
										$args = array ( 'category' => $category->term_id, 'posts_per_page' => 5);
										$myposts = get_posts( $args );
										foreach( $myposts as $post ) :	setup_postdata($post);
										?>
										<div class="item image5">
									    	<div class="wow fadeIn" data-wow-duration="2s">
									    		<?php if (has_post_thumbnail()) : ?>
										  		<?php the_post_thumbnail('full', array('class' => 'img-responsive center-block')); ?>
												<?php else : ?>
													<div class="no-img"><i class="fa fa-camera-retro fa-5x"></i></div>
												<?php endif; ?>
										    </div>
										    <div class="carousel-caption wow slideInLeft" data-wow-duration="2s">
										    	<div class="container">
										      		<h2><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute();?>"><?php the_title();?></a></h2>
										      	</div>
										    </div>
									    </div><!-- .item -->
									<?php endforeach; ?>
						        	
								</div>
								<a class="left carousel-control" href="#carousel-whiteboard64-pro" data-slide="prev">
									<span class="icon-prev"></span>
								</a>
								<a class="right carousel-control" href="#carousel-whiteboard64-pro" data-slide="next">
									<span class="icon-next"></span>
								</a>
							</div> <!-- carousel slider -->
						</div> <!-- categoryposts-slider -->

						<div class="clearfix"></div>
						<?php }?>


						<?php
						/* Start the Loop */
						while ( have_posts() ) : the_post();
							/*
							 * Include the Post-Format-specific template for the content.
							 * If you want to override this in a child theme, then include a file
							 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
							 */
							get_template_part( 'template-parts/content', get_post_format() );
						endwhile;
						the_posts_navigation();
					else :
						get_template_part( 'template-parts/content', 'none' );
					endif; ?>
				</div><!-- .col-md-9 -->

				<?php  if ($sidebar == 'right'){             
				  	get_sidebar('right');            
				  	}
				?>

			</div><!-- .container -->
		</main><!-- #main -->
	</div><!-- #primary -->

<?php
get_footer();