<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Whiteboard64 Pro
 */

get_header(); ?>
	
	<div class="innerpage">
		<img src="<?php header_image(); ?>" class="header-image feaImg img-responsive center-block" />
	</div>
	
	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">
			<div class="container">

				<?php
				  	$class = 'col-md-12';
				  	$sidebar =  get_theme_mod('page_not_found_sidebar_position');
				   		if($sidebar != 'none'){
				      	$class = 'col-md-9';
				  	}
				?> 
				<?php
				  if ($sidebar == 'left'){			     
				      	get_sidebar('left');
				    }
				?>
				<div class="<?php echo $class;?> detail-content">
					<section class="error-404 not-found">
						<header class="page-header">
							<h1 class="page-title text-center"><?php esc_html_e( 'Oops! That page can&rsquo;t be found.', 'whiteboard64-pro' ); ?></h1>
						</header><!-- .page-header -->

						<div class="page-content">
							<div class="col-sm-12 notfound">
								<p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'whiteboard64-pro' ); ?></p>
								<?php get_search_form(); ?>
							</div>

							<?php
								the_widget( 'WP_Widget_Recent_Posts' );
								// Only show the widget if site has multiple categories.
								if ( whiteboard64_pro_categorized_blog() ) :
							?>

							<div class="widget widget_categories">
								<h2 class="widgettitle"><?php esc_html_e( 'Most Used Categories', 'whiteboard64-pro' ); ?></h2>
								<ul>
								<?php
									wp_list_categories( array(
										'orderby'    => 'count',
										'order'      => 'DESC',
										'show_count' => 1,
										'title_li'   => '',
										'number'     => 10,
									) );
								?>
								</ul>
							</div><!-- .widget -->

							<?php
								endif;

								/* translators: %1$s: smiley */
								$archive_content = '<p>' . sprintf( esc_html__( 'Try looking in the monthly archives. %1$s', 'whiteboard64-pro' ), convert_smilies( ':)' ) ) . '</p>';
								the_widget( 'WP_Widget_Archives', 'dropdown=1', "after_title=</h2>$archive_content" );

								the_widget( 'WP_Widget_Tag_Cloud' );
							?>

						</div><!-- .page-content -->
					</section><!-- .error-404 -->
				</div>

				<?php  if ($sidebar == 'right'){             
				  	get_sidebar('right');            
				  	}
				?>

			</div><!-- .container -->
		</main><!-- #main -->
	</div><!-- #primary -->

<?php
get_footer();